// -*- C++ -*-
#ifndef SEQ_H
#define SEQ_H

#include <list>
#include <queue>
#include <iostream>
#include <iomanip>
#include <math.h>
#include <boost/bind.hpp>
#include <rtm/Manager.h>
#include <rtm/DataFlowComponentBase.h>
#include <rtm/CorbaPort.h>
#include <rtm/DataInPort.h>
#include <rtm/DataOutPort.h>
#include <rtm/idl/BasicDataTypeSkel.h>
#include <services/StateService/StateManagerService.h>
#include <services/CommandService/CommandService_impl.h>
#include <utils/UtilTimer.h> 
#include <utils/Semaphore.h>
#include <coil/stringutil.h>
#include "StateSequencer.h"

// Service implementation headers
// <rtc-template block="service_impl_h">

// </rtc-template>

// Service Consumer stub headers
// <rtc-template block="consumer_stub_h">

// </rtc-template>

using namespace RTC;

typedef std::queue <std::pair <std::vector<double>, double> > AnglevectorTimeList;

class Seq
    : public RTC::DataFlowComponentBase
{
public:
    Seq(RTC::Manager* manager);
    ~Seq();

    // The initialize action (on CREATED->ALIVE transition)
    // formaer rtc_init_entry() 
    virtual RTC::ReturnCode_t onInitialize();

    // The finalize action (on ALIVE->END transition)
    // formaer rtc_exiting_entry()
    // virtual RTC::ReturnCode_t onFinalize();

    // The startup action when ExecutionContext startup
    // former rtc_starting_entry()
    // virtual RTC::ReturnCode_t onStartup(RTC::UniqueId ec_id);

    // The shutdown action when ExecutionContext stop
    // former rtc_stopping_entry()
    // virtual RTC::ReturnCode_t onShutdown(RTC::UniqueId ec_id);

    // The activated action (Active state entry action)
    // former rtc_active_entry()
    virtual RTC::ReturnCode_t onActivated(RTC::UniqueId ec_id);

    // The deactivated action (Active state exit action)
    // former rtc_active_exit()
    virtual RTC::ReturnCode_t onDeactivated(RTC::UniqueId ec_id);

    // The execution action that is invoked periodically
    // former rtc_active_do()
    virtual RTC::ReturnCode_t onExecute(RTC::UniqueId ec_id);

    // The aborting action when main logic error occurred.
    // former rtc_aborting_entry()
    // virtual RTC::ReturnCode_t onAborting(RTC::UniqueId ec_id);

    // The error action in ERROR state
    // former rtc_error_do()
    // virtual RTC::ReturnCode_t onError(RTC::UniqueId ec_id);

    // The reset action that is invoked resetting
    // This is same but different the former rtc_init_entry()
    // virtual RTC::ReturnCode_t onReset(RTC::UniqueId ec_id);
  
    // The state update action that is invoked after onExecute() action
    // no corresponding operation exists in OpenRTm-aist-0.2.0
    // virtual RTC::ReturnCode_t onStateUpdate(RTC::UniqueId ec_id);

    // The action that is invoked when execution context's rate is changed
    // no corresponding operation exists in OpenRTm-aist-0.2.0
    // virtual RTC::ReturnCode_t onRateChanged(RTC::UniqueId ec_id);

    void ResetPriorities(int* maskv, int seqprio, int length)
        {
            for(int i=0;i<length;i++)
                if((maskv[i] > 0) && (current_priorities[i] == seqprio)) current_priorities[i] = 0;
        }

protected:
    // Configuration variable declaration
    std::string m_componentconf_file;
    std::string m_config;

    // DataInPort declaration
    // <rtc-template block="inport_declare">
    StateManagerService m_inStateManager;
    RTMEUS::TimedStateSet m_inState;
    InPort<RTMEUS::TimedStateSet> m_inStatePort;
    // </rtc-template>

    // DataOutPort declaration
    // <rtc-template block="outport_declare">
    StateManagerService m_outStateManager;
    RTMEUS::TimedStateSet m_outState;
    OutPort<RTMEUS::TimedStateSet> m_outStatePort;
    // </rtc-template>

    // CORBA Port declaration
    // <rtc-template block="corbaport_declare">
    // </rtc-template>
    RTC::CorbaPort m_stateServicePort;
    RTC::CorbaPort m_CommandServicePort;

    // Service declaration
    // <rtc-template block="service_declare">
    // </rtc-template>
    StateManagerService m_stateServiceManager;
    CommandService_impl m_commandservice;

    // Consumer declaration
    // <rtc-template block="consumer_declare">

    // </rtc-template>

private:
    //
    std::string angle_vector(const std::string &argv);
    std::string angle_vector_sequence(const std::string &argv);
    std::string pop_and_set_angle_vector(std::string seqname, std::string imethod, bool overwriteflag);
    std::string set_anglevectortimelist(const std::string &argv);
    std::string wait_interpolation(const std::string &argv);
    std::string wait_all_interpolation(const std::string &argv);
    std::string adapt(const std::string &argv);
    std::string adapt_1motor(const std::string &argv);
    std::string adapt_allseq(const std::string &argv);
    std::string adapt_1motor_allseq(const std::string &argv);
    std::string get_interpolated_vector(const std::string &argv);
    std::string create_newsequencer(const std::string &argv);
    std::string set_sequencer_priority(const std::string &argv);
    std::string get_sequencer_priority(const std::string &argv);
    std::string set_sequencer_mask(const std::string &argv);
    std::string get_sequencer_mask(const std::string &argv);
    std::string set_sequencer_integrationmethod(const std::string &argv);
    std::string set_sequencer_motionspeed(const std::string &argv);
    std::string set_sequencer_motiongain(const std::string &argv);
    void speed_smoothing(float* curv,int size);

    // Sequencerのためのステートを保持(pos, vel, accelとか)
    StateManager m_seqStateManager;

    // シーケンサの情報
    struct SequencerInfo {
        std::string potentio_name;
        RTMEUS::StateProfile prof;
    };
    typedef std::map< std::string, SequencerInfo >::iterator SequencerInfoItr;
    std::map< std::string, SequencerInfo > m_seqInfos;

    // シーケンサの状態
    struct SequencerState {
        SequencerState() {sem = boost::shared_ptr<MonitorSem>(new MonitorSem());}
        StateSequencerPtr sequencer;
        boost::shared_ptr<MonitorSem> sem;
    };
    //
    typedef std::map< std::string, SequencerState >::iterator SequencerStateItr;
    std::map< std::string, SequencerState > m_sequencers;
    std::vector<int> current_priorities;
    //
    coil::Mutex m_sequencers_lock;
    // 一回目のonExecute?
    bool m_first;
    // タイマー(stepNextのために必要)
    UtilTimer  m_timer;
    //dataと補間時間の組合せの格納場所
    std::map<std::string, AnglevectorTimeList > m_AnglevectorTimeLists;
	
    //for smoothing
    float  *m_state_target,*m_state_potentio;
    float m_anglevel_limit;

    //
    coil::Mutex slock;
    MutexCond scond;
};

extern "C"
{
    void SeqInit(RTC::Manager* manager);
};

#endif // SEQ_H
