// -*- C++ -*-
#include <rtm/Manager.h>
#include <iostream>
#include <string>
#include "Seq.h"


void MyModuleInit(RTC::Manager* manager)
{
    SeqInit(manager);
    RTC::RtcBase* comp;
    char* rtmeusdir;
    char* archdir;
    char mod_path[128];

    rtmeusdir = getenv("RTMEUSDIR");
    archdir = getenv("ARCHDIR");

    sprintf(mod_path,"%s/RTMEus/%s/lib/SoftRealtimePeriodicExecutionContext.so", rtmeusdir, archdir);
  
    // Create a component
    manager->load(mod_path, "SoftRealtimePeriodicExecutionContextInit");
    manager->getConfig().setProperty("exec_cxt.periodic.rate", "30");
    manager->getConfig().setProperty("exec_cxt.periodic.type", "SoftRealtimePeriodicExecutionContext");

    comp = manager->createComponent("Seq");

    return;
}

int main (int argc, char** argv)
{
    RTC::Manager* manager;
    manager = RTC::Manager::init(argc, argv);

    // Initialize manager
    manager->init(argc, argv);

    // Set module initialization proceduer
    // This procedure will be invoked in activateManager() function.
    manager->setModuleInitProc(MyModuleInit);

    // Activate manager and register to naming service
    manager->activateManager();

    // run the manager in blocking mode
    // runManager(false) is the default.
    manager->runManager();

    // If you want to run the manager in non-blocking mode, do like this
    // manager->runManager(true);

    return 0;
}
